<?php

require_once 'head.php';
require '/home/membera1/public_html/nu.memberadams.top/usrs/porounumber/DB.php';

$DB = new DB;

$selectedChatId = @$_GET['chat_id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $amount = $_POST['amount'];
    $description = $_POST['description'];

    $DB->createPayment($selectedChatId, 'zarinpal', $amount, null, $description, $_SERVER['REMOTE_ADDR'], 1);

    if (str_starts_with($amount, '+'))
        $DB->increaseWallet(substr($amount, 1), $selectedChatId);
    else
        $DB->decreaseWallet(substr($amount, 1), $selectedChatId);
}

if ($selectedChatId) {
    $payments = $DB->getPaymentByChatId($selectedChatId);

    $selectedUser = $DB->getUserByChatId($selectedChatId);
} else {
    $currentPage = $_GET['page'] ?? 1;

    if (!is_numeric($currentPage))
        $currentPage = 1;

    // get q
    $q = @$_GET['q'];

    // get payments
    $payments = $DB->getPaymentsWithPagination(($currentPage - 1) * 50, $q);

    // get payments count
    $paymentsCount = $DB->getPaymentsCount($q);
    $pagesCount = $paymentsCount / 50;
}

?>
<?php include 'partials/header.php' ?>
<?php if (isset($currentPage)): ?>
    <form accept="<?= $_SERVER['PHP_SELF'] ?>" class="max-w-md mb-3">
        <div class="relative">
            <div class="absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none">
                <svg class="w-4 h-4 text-gray-500" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
                </svg>
            </div>
            <input type="search" name="q" value="<?= $q ?>" class="block w-full p-3 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500" placeholder="جستجو..." />
            <button type="submit" class="text-white absolute end-2.5 bottom-1.5 bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-4 py-2">جستجو</button>
        </div>
    </form>
<?php else: ?>
    <?php if (isset($amount)): ?>
        <div class="flex items-center p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-100" role="alert">
            <svg class="flex-shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
            </svg>
            <div>
                با موفقیت اضافه شد...
            </div>
        </div>
    <?php endif ?>
    <div class="flex flex-col mb-5">
        <a href="/porounumber/wallet.php?chat_id=<?= $selectedChatId ?>" class="bg-yellow-500 rounded py-1 px-2 w-fit text-sm">افزودن</a>

        <div class="flex mt-3">
            <p class="bg-gray-800 text-white rounded p-1.5 text-sm">موجودی: <?= $selectedUser['wallet'] ?> تومان</p>
        </div>
    </div>
<?php endif ?>
<table class="w-full text-sm text-left rtl:text-right text-gray-500">
    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
        <tr>
            <th scope="col" class="px-6 py-3">
                چت آیدی
            </th>
            <th scope="col" class="px-6 py-3">
                مقدار
            </th>
            <th scope="col" class="px-6 py-3">
                توضیحات
            </th>
            <th scope="col" class="px-6 py-3">
                کد رهگیری
            </th>
            <th scope="col" class="px-6 py-3">
                آیپی
            </th>
            <th scope="col" class="px-6 py-3">
                وضعیت
            </th>
            <th scope="col" class="px-6 py-3">
                تاریخ
            </th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($payments as $payment): ?>
            <tr class="odd:bg-white even:bg-gray-50 bg-white border-b">
                <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                    <?= $payment['chat_id'] ?>
                </th>
                <td class="px-6 py-4">
                    <?= number_format($payment['amount']) ?>
                </td>
                <td class="px-6 py-4">
                    <?= $payment['description'] ?? ('سفارش: ' . $payment['id']) ?>
                </td>
                <td class="px-6 py-4">
                    <?= $payment['ref'] ?>
                </td>
                <td class="px-6 py-4">
                    <?= $payment['ip'] ?>
                </td>
                <td class="px-6 py-4">
                    <?= $payment['is_paid'] ? 'پرداخت شده' : 'پرداخت نشده' ?>
                </td>
                <td class="px-6 py-4">
                    <?= jdate($payment['created_at']) ?>
                </td>
            </tr>
        <?php endforeach ?>
    </tbody>
</table>
<?php if (isset($currentPage)): ?>
    <nav class="mt-5 mb-0.5 flex items-center flex-column flex-wrap md:flex-row justify-center pt-4" aria-label="Table navigation">
        <!-- <span class="text-sm font-normal text-gray-500 dark:text-gray-400 mb-4 md:mb-0 block w-full md:inline md:w-auto">Showing <span class="font-semibold text-gray-900 dark:text-white">1-10</span> of <span class="font-semibold text-gray-900 dark:text-white">1000</span></span> -->
        <ul class="inline-flex -space-x-px rtl:space-x-reverse text-sm h-8">
            <li>
                <a <?php if ($pagesCount > $currentPage): ?> href="/porounumber/payments.php?page=<?= $currentPage + 1 ?>" <?php else : ?> href="#" <?php endif ?> class="flex items-center justify-center px-3 h-8 ms-0 leading-tight text-gray-500 bg-white border border-gray-300 rounded-s-lg hover:bg-gray-100 hover:text-gray-700">بعدی</a>
            </li>
            <?php for ($i = 0; $i++; $i < $pagesCount): ?>
                <li>
                    <a href="/porounumber/payments.php?page=<?= $page ?>" class="flex items-center justify-center px-3 h-8 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700"><?= $page ?></a>
                </li>
            <?php endfor ?>
            <li>
                <a
                    <?php if ($currentPage > 1): ?> href="/porounumber/payments.php?page=<?= $currentPage - 1 ?>" <?php else : ?> href="#" <?php endif ?> class="flex items-center justify-center px-3 h-8 leading-tight text-gray-500 bg-white border border-gray-300 rounded-e-lg hover:bg-gray-100 hover:text-gray-700">قبلی</a>
            </li>
        </ul>
    </nav>
<?php endif ?>
<?php include 'partials/footer.php' ?>