<?php

require 'head.php';
require '/home/membera1/public_html/nu.memberadams.top/usrs/porounumber/DB.php';

$DB = new DB;

$currentPage = $_GET['page'] ?? 1;

if (!is_numeric($currentPage))
    $currentPage = 1;

// get q
$q = @$_GET['q'];

// get users
$users = $DB->getUsersWithPagination(($currentPage - 1) * 50, $q);

// get users count
$usersCount = $DB->getUsers($q);
$pagesCount = $usersCount / 50;

function getUserLimitInString($user)
{
    return match ((int)$user['limit']) {
        0 => 'هیچی',
        1 => 'پشتیبانی',
        2 => 'ربات',
        default => 'نامشخص'
    };
}

?>

<?php include 'partials/header.php' ?>
<form accept="<?= $_SERVER['PHP_SELF'] ?>" class="max-w-md mb-3">
    <div class="relative">
        <div class="absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none">
            <svg class="w-4 h-4 text-gray-500" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
            </svg>
        </div>
        <input type="search" name="q" value="<?= $q ?>" class="block w-full p-3 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500" placeholder="جستجوی آیدی عددی..." />
        <button type="submit" class="text-white absolute end-2.5 bottom-1.5 bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-4 py-2">جستجو</button>
    </div>
</form>
<table class="w-full text-sm text-left rtl:text-right text-gray-500">
    <thead class="text-xs text-gray-700 uppercase bg-gray-50">
        <tr>
            <th scope="col" class="px-6 py-3">
                چت آیدی
            </th>
            <th scope="col" class="px-6 py-3">
                نام
            </th>
            <th scope="col" class="px-6 py-3">
                موجودی
            </th>
            <th scope="col" class="px-6 py-3">
                محدودیت
            </th>
            <th scope="col" class="px-6 py-3">
                وضعیت
            </th>
            <th scope="col" class="px-6 py-3">
                تاریخ ساخت
            </th>
            <th scope="col" class="px-6 py-3">
                عملیات
            </th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $user): ?>
            <tr class="odd:bg-white even:bg-gray-50 bg-white border-b">
                <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap">
                    <?= $user['chat_id'] ?>
                </th>
                <td class="px-6 py-4">
                    <?= $user['first_name'] ?>
                </td>
                <td class="px-6 py-4">
                    <?= $user['wallet'] ?>
                </td>
                <td class="px-6 py-4">
                    <button id="<?= 'dropdown-button-' . $user['chat_id'] ?>" data-dropdown-toggle="<?= 'dropdownRadioBgHover-' . $user['chat_id'] ?>" class="text-blue-700 border border-blue-700 hover:bg-blue-700 hover:text-white focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center inline-flex items-center" type="button"><?= getUserLimitInString($user) ?> <svg class="w-2.5 h-2.5 ms-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4" />
                        </svg>
                    </button>

                    <!-- Dropdown menu -->
                    <div id="<?= 'dropdownRadioBgHover-' . $user['chat_id'] ?>" data-chat-id="<?= $user['chat_id'] ?>" class="dropdown z-10 hidden w-48 bg-white divide-y divide-gray-100 rounded-lg shadow">
                        <ul class="p-3 space-y-1 text-sm text-gray-700" aria-labelledby="<?= 'dropdown-button-' . $user['chat_id'] ?>">
                            <li>
                                <div class="flex items-center p-2 rounded hover:bg-gray-100">
                                    <input <?= $user['limit'] == 0 ? 'checked' : '' ?> id="<?= 'radio-1-' . $user['chat_id'] ?>" type="radio" data-value="هیچی" value="none" name="<?= 'radio-' . $user['chat_id'] ?>" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500">
                                    <label for="<?= 'radio-1-' . $user['chat_id'] ?>" class="w-full ms-2 text-sm font-medium text-gray-900 rounded">هیچی</label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center p-2 rounded hover:bg-gray-100">
                                    <input <?= $user['limit'] == 1 ? 'checked' : '' ?> id="<?= 'radio-2-' . $user['chat_id'] ?>" type="radio" data-value="پشتیبانی" value="support" name="<?= 'radio-' . $user['chat_id'] ?>" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500">
                                    <label for="<?= 'radio-2-' . $user['chat_id'] ?>" class="w-full ms-2 text-sm font-medium text-gray-900 rounded">پشتیبانی</label>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center p-2 rounded hover:bg-gray-100">
                                    <input <?= $user['limit'] == 2 ? 'checked' : '' ?> id="<?= 'radio-3-' . $user['chat_id'] ?>" type="radio" data-value="بات" value="bot" name="<?= 'radio-' . $user['chat_id'] ?>" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500">
                                    <label for="<?= 'radio-3-' . $user['chat_id'] ?>" class="w-full ms-2 text-sm font-medium text-gray-900 rounded">بات</label>
                                </div>
                            </li>
                        </ul>
                    </div>
                </td>
                <td class="px-6 py-4">
                    <?= $user['account_status'] == 1 ? 'فعال' : ($user['account_status'] == -1 ? 'حذف' : 'بلاک') ?>
                </td>
                <td class="px-6 py-4">
                    <?= jdate($user['created_at'])->format('Y-m-d') ?>
                </td>
                <td class="px-6 py-4 flex gap-x-1">
                    <a href="/porounumber/payments.php?chat_id=<?= $user['chat_id'] ?>" class="font-medium text-gray-500 hover:underline">موجودی</a>
                    <p>|</p>
                    <a href="/porounumber/message.php?chat_id=<?= $user['chat_id'] ?>" class="font-medium text-gray-500 hover:underline">پشتیبانی</a>
                </td>
            </tr>
        <?php endforeach ?>
    </tbody>
</table>
<nav class="mt-5 mb-0.5 flex items-center flex-column flex-wrap md:flex-row justify-center pt-4" aria-label="Table navigation">
    <ul class="inline-flex -space-x-px rtl:space-x-reverse text-sm h-8">
        <li>
            <a <?php if ($pagesCount > $currentPage): ?> href="/porounumber?page=<?= $currentPage + 1 ?>" <?php else : ?> href="#" <?php endif ?> class="flex items-center justify-center px-3 h-8 ms-0 leading-tight text-gray-500 bg-white border border-gray-300 rounded-s-lg hover:bg-gray-100 hover:text-gray-700">بعدی</a>
        </li>
        <?php for ($i = 0; $i++; $i < $pagesCount): ?>
            <li>
                <a href="/porounumber?page=<?= $page ?>" class="flex items-center justify-center px-3 h-8 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700"><?= $page ?></a>
            </li>
        <?php endfor ?>
        <li>
            <a
                <?php if ($currentPage > 1): ?> href="/porounumber?page=<?= $currentPage - 1 ?>" <?php else : ?> href="#" <?php endif ?> class="flex items-center justify-center px-3 h-8 leading-tight text-gray-500 bg-white border border-gray-300 rounded-e-lg hover:bg-gray-100 hover:text-gray-700">قبلی</a>
        </li>
    </ul>
</nav>
<script>
    document.querySelectorAll('.dropdown').forEach(dropdown => {
        let inputs = dropdown.querySelectorAll('input')

        inputs.forEach(checkbox => {
            checkbox.addEventListener('change', async () => {
                // delete all checks
                // inputs.forEach(input => {
                //     input.removeAttribute('checked')
                // })

                // checkbox.setAttribute('checked', '')
                let chatId = dropdown.getAttribute('data-chat-id')

                document.querySelector(`#dropdown-button-${chatId}`).innerHTML = checkbox.getAttribute('data-value') + `<svg class="w-2.5 h-2.5 ms-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4" />
                        </svg>`

                // send xhr request to backend and set limit
                let result = await fetch('/porounumber/change-user-limit.php', {
                    method: 'post',
                    body: JSON.stringify({
                        chat_id: chatId,
                        limit: checkbox.value
                    })
                })
            })
        })
    })
</script>
<?php include 'partials/footer.php' ?>